<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Sambutan Kepala Sekolah') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  <style>
    .sidebar { width: 280px; min-height: 100vh; overflow-y: auto; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
    .sub-menu { padding-left: 1rem; }
    .sub-menu .list-group-item {
      font-size: 0.9rem;
      padding: 0.5rem 1rem;
      border: none;
    }
    .menu-toggle {
      cursor: pointer;
      position: relative;
    }
    .menu-toggle::after {
      content: '▼';
      position: absolute;
      right: 1rem;
      font-size: 0.75rem;
      transition: transform 0.3s;
    }
    .menu-toggle.collapsed::after {
      transform: rotate(-90deg);
    }
    body { background: #f6f8fb; }
    .page-wrap { max-width: 980px; }
    .hero-title { letter-spacing: .2px; }
    .soft-card {
      border: 0;
      border-radius: 18px;
      box-shadow: 0 10px 30px rgba(16, 24, 40, .08);
    }
    .btn-rounded { border-radius: 999px; padding-inline: 18px; }
    .hint { color: #667085; font-size: .9rem; }
    .main-content { flex: 1; }
    label {
      display: block;
      font-weight: 600;
      font-size: 14px;
      color: #344054;
      margin: 0 0 8px 0;
    }
    input[type="text"], 
    input[type="file"],
    textarea {
      width: 100%;
      padding: 12px 14px;
      border: 1px solid #d0d5dd;
      border-radius: 14px;
      background: #fff;
      font-size: 14px;
      color: #1f2937;
      transition: all 0.2s;
    }
    input[type="text"]:focus,
    textarea:focus {
      outline: none;
      border-color: #2563eb;
      box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
    }
    input[type="file"] {
      padding: 10px 14px;
      cursor: pointer;
      font-size: 13px;
    }
    .form-group {
      margin-bottom: 20px;
    }
    .preview-wrapper {
      margin-top: 14px;
      padding: 14px;
      background: #f9fafb;
      border-radius: 12px;
      border: 1px solid #e5e7eb;
    }
    .preview-label {
      font-size: 13px;
      color: #667085;
      margin: 0 0 10px 0;
    }
    img.preview {
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      max-width: 100%;
      display: block;
      background: #fff;
      max-height: 180px;
      object-fit: contain;
    }
    .btn {
      padding: 12px 24px;
      border-radius: 999px;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.2s;
    }
    .btn-primary {
      background: #2563eb;
      color: #fff;
      border: none;
    }
    .btn-primary:hover {
      background: #1d4ed8;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(37, 99, 235, 0.25);
    }
    .alert-success {
      background: #d1fae5;
      color: #065f46;
      padding: 14px 16px;
      border-radius: 12px;
      margin-bottom: 24px;
      border: 1px solid #a7f3d0;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
 
    /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
    .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>

  <!-- Main Content -->
  <div class="main-content">
    <div class="container py-4 page-wrap">

      <!-- Header -->
      <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3 mb-4">
        <div>
          <h1 class="h3 mb-1 hero-title">Kata Sambutan Kepala Sekolah</h1>
          <div class="hint">Kelola sambutan dan informasi kepala sekolah.</div>
        </div>
      </div>

      <!-- Alert -->
      <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
          <div>✅</div>
          <div><?= session()->getFlashdata('success') ?></div>
        </div>
      <?php endif; ?>

      <!-- Card -->
      <div class="card soft-card">
        <div class="card-body p-4 p-md-5">

          <div class="d-flex align-items-start justify-content-between flex-wrap gap-3 mb-3">
            <div>
              <div class="fw-semibold">Edit Konten</div>
              <div class="hint">Isi informasi kepala sekolah yang akan ditampilkan di halaman publik.</div>
            </div>
          </div>

          <form action="<?= site_url('admin/kepsek/update') ?>" method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>

            <div class="form-group">
              <label>Nama Kepala Sekolah</label>
              <input type="text" name="kepsek_nama" value="<?= esc($row['kepsek_nama'] ?? '') ?>" placeholder="Contoh: Dr. H. Ahmad Supriyadi, M.Pd">
            </div>

            <div class="form-group">
              <label>Judul Highlight</label>
              <input type="text" name="kepsek_judul_highlight" value="<?= esc($row['kepsek_judul_highlight'] ?? '') ?>" placeholder="Misal: SMAS SENTOSA BHAKTI">
              <div class="hint mt-2">Nama sekolah atau judul yang akan di-highlight pada sambutan.</div>
            </div>

            <div class="form-group">
              <label>Sambutan</label>
              <textarea name="kepsek_sambutan" rows="8" placeholder="Tulis kata sambutan kepala sekolah..."><?= esc($row['kepsek_sambutan'] ?? '') ?></textarea>
              <div class="hint mt-2">Tulis pesan dan sambutan kepala sekolah untuk pengunjung website.</div>
            </div>

            <div class="form-group">
              <label>Foto Kepala Sekolah (Opsional)</label>
              <input type="file" name="kepsek_foto" accept="image/*">
              <div class="hint">Format: JPG, PNG (Maks. 2MB)</div>

              <?php if (!empty($row['kepsek_foto'])): ?>
                <div class="preview-wrapper">
                  <div class="preview-label">Foto saat ini:</div>
                  <img class="preview" src="<?= base_url($row['kepsek_foto']) ?>" alt="Foto Kepala Sekolah">
                </div>
              <?php else: ?>
                <div class="hint" style="margin-top:12px;">Belum ada foto tersimpan.</div>
              <?php endif; ?>
            </div>

            <hr class="my-4">

            <div class="btnrow">
              <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
            </div>
          </form>

        </div>
      </div>

      <div class="hint text-center mt-4">
        © <?= date('Y') ?> Admin Panel
      </div>

    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- TAMBAHAN JS (AMAN) -->
<script>
  function toggleSidebar() {
    document.getElementById('sidebar').classList.toggle('show');
    document.querySelector('.sidebar-overlay').classList.toggle('show');
  }
</script>
</body>
</html>